function fit = linfit
clear
c = 0;
h=@model;
while c ~= 2
    c = menu('','Data Fitting', 'Exit');
    if c == 1
       disp ('-------------')
       disp ('Data Fitting')
       disp ('-------------')
  %     close all
  
       [filename, pathname, filterindex] = uigetfile('*', 'file dati: X , DeltaX, Y, DeltaY');
       disp (['Selected file is ', pathname, filename]); 
       data  = load('brewster.dat');
       %data = load([pathname, filename]);
       
       x = data(:,1);
       dx = data(:,2);
       y = data(:,3);
       dy = data(:,4);

       figure
       
       errorbar(x, y, dy, '.')
       hold
       herrorbar(x, y, dx, '.')
       hold

     %%%%%%%%%  addpath ..\3\fitChiSquare
       
       p(1) = 1.4;        % valore iniziale fth     
       p(2) = 400;     % valore iniziale Rth 
       
       % Set up the optimization options here.  See the optimset help file for
       % more information.
       op = optimset;          % Default optimization options
       op.DisplayUncVal = 1;   % Display iterative uncertainty information
       op.Display = 'on';      % Display fit output and plot result
       op.LowerBound = [-10000000 -1000000];  % Estremi inferiori per i due parametri
       op.UpperBound = [ 10000000  10000000]; % ... ed estremi superiori
       op.ErrorsUnknown = 0;
       op.FitUncertainty = [1 1];
       op.FixIndex = [1 1];
       op.Plot = 1;
       op.PlotResiduals = 1;
       op.Scale = 1;

       % ------------------- PROCEDURE --------------------------------------
       % Used to time the fitting
       tic;

       figure
       
       % Perform the fit, par(1) e' il delta, par(2) e' n
       [fit.params,fit.dParams,fit.gof,fit.stddev] = ...
           fitChiSquare(x,y,h,p,dx,dy,op);

       % Display elapsed time
       disp(sprintf('Time = %fs', toc));      
    end
end
    function result = model(params,x)
    
    
    % k*(((n^2*cos(x) - sqrt(n^2 - (sin(x))^2))/(n^2*cos(x) + sqrt(n^2 - (sin(x))^2)))^2)
    
    result =  params(2)*(((params(1)^2*cos(x*pi/180) - sqrt(params(1)^2 - (sin(x*pi/180)).^2))./ (params(1).^2*cos(x*pi/180) + sqrt(params(1)^2 - (sin(x*pi/180)).^2))).^2);
    
    % nella sintassi di matlab x e result sono matrici (in questo caso
    % matrici riga) e gli operatori agiscono secondo le regole delle
    % operazioni tra matrici. l'operatore ./ indica invece la divisione
    % elemento per elemento.
     end
    end
