function fit = data2FitChiSquare

% Set up the data and model parameters here

load data2.txt;
x  = data2(:,1);
y  = data2(:,2);
dx = data2(:,3);
dy = data2(:,4);

p(1) = 0;       % Model parameter 1
p(2) = 1;       % Model parameter 2

% Set up the optimization options here.  See the optimset help file for
% more information.
op = optimset;          % Default optimization options
op.DisplayUncVal = 1;   % Display iterative uncertainty information
op.Display = 'on';      % Display fit output and plot result
op.LowerBound = [0 0];
op.UpperBound = [ 100  100];
op.ErrorsUnknown = 0;
op.FitUncertainty = [1 1 1];
op.Plot = 1;
op.PlotResiduals = 1;
op.Scale = 1;

% ------------------- PROCEDURE --------------------------------------

% Used to time the fitting
tic;

% Perform the fit
[fit.params,fit.dParams,fit.gof,fit.stddev] = ...
    fitChiSquare(x,y,@data2ModelFun,p,dx,dy,op);

% Display elapsed time
disp(sprintf('Time = %fs', toc));

end
